import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../util/processResponse.js";

const URL = `${BASE_API_URL_STG}/user/categories/all?status=Active`;

const initialState = {
    allCategory: [],
    loading: true,
    isRefresh: false,
    nextPageUrl: "",
    loadMore: false,
};

export const getAllCategory = createAsyncThunk(
    "items/getAllCategory",
    async () => {
        const data = await queryResponse(URL, "GET");
        return data;
    }
);
export const getMoreCategory = createAsyncThunk(
    "items/getMoreCategory",
    async ({ nextPageUrl }) => {
        const data = await queryResponse(nextPageUrl, "GET");
        return data;
    }
);

const allCategorySlice = createSlice({
    name: "items",
    initialState,
    reducers: {
        fetchCategoryStart: (state) => {
            state.isRefresh = true;
        },
        getAllCategoryWithoutLoading: (state, action) => {
            state.allCategory = action.payload;
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getAllCategory.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getAllCategory.fulfilled, (state, { payload }) => {
            const { status, records: { data, pagination } = {} } =
                payload || {};
            if (status?.code == 200) {
                const allCategory = data?.filter(
                    (item) => item.slug != "uncategorized"
                );
                state.allCategory = allCategory;
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loading = false;
        });
        builder.addCase(getAllCategory.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreCategory.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(getMoreCategory.fulfilled, (state, { payload }) => {
            const { status, records: { data, pagination } = {} } =
                payload || {};
            if (status?.code == 200) {
                const allCategory = data?.filter(
                    (item) => item.slug != "uncategorized"
                );
                state.allCategory = [...state.allCategory, ...allCategory];
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loadMore = false;
        });
        builder.addCase(getMoreCategory.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { fetchCategoryStart, getAllCategoryWithoutLoading } =
    allCategorySlice.actions;

export default allCategorySlice.reducer;
